//
//  HexUtil.h
//  HexUtil
//
//  Created by Tam Nguyen on 5/5/15.
//  Copyright (c) 2015 MagTek. All rights reserved.
//

#import <Foundation/Foundation.h>

#define CardHexValueMap @{ \
        @"AmericanExpress":       @"76312e3030", \
        @"MasterCard":            @"76312e3034", \
        @"Visa":                  @"76312e30", \
        @"Discover":              @"76312e3030", \
        @"Interac":               @"76312e3030", \
        @"GooglePaySmartTap":     @"76322e31" \
}

#define CardAIDsMap @{ \
        @"AmericanExpress":       @[@"A00000002501"], \
        @"MasterCard":            @[@"A0000000041010", @"A0000000043060", @"A0000000042203"], \
        @"Visa":                  @[@"A0000000031010", @"A0000000032010", @"A0000000033010", @"A0000000038010"], \
        @"Discover":              @[@"A0000003241010", @"A0000001523010", @"A0000000659001", @"A0000000651010"], \
        @"Interac":               @[@"A0000002771010"], \
        @"GooglePaySmartTap":     @[@"A000000476D0000111"] \
}

@interface HexUtil : NSObject

+ (NSString *) toHex:(NSData *)aData;
+ (NSString *)toHex:(NSData *)data offset:(uint)offset len:(NSUInteger)len;
+ (NSData *)getBytesFromHexString:(NSString*)strIn;
+ (NSData *) dataFromHexString:(NSString*)stringIn;
+ (NSString *)stringFromHexString:(NSString *)hexString;
@end
